/*
 * Decompiled with CFR 0.152.
 */
package com.openlm.userimport;

import com.openlm.userimport.User;
import com.openlm.userimport.api.IOpenLMServerAPI;
import com.openlm.userimport.api.xml.Groups;
import com.openlm.userimport.api.xml.XmlAPI;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class Main {
    static final String OPEN_LM_EVERYONE = "OpenLM_Everyone";
    final Properties configuration;
    final IOpenLMServerAPI serverApi;
    final File csv;
    final String listDelimiter = "\\|";
    final Map<String, String> groups = new HashMap<String, String>();
    final Map<String, String> projects = new HashMap<String, String>();
    final List<String> userNamesToImport = new ArrayList<String>();
    final boolean mergeUserDetailsOnUpdate;
    final boolean allowToAddMissingEntities;
    final char delimiter;
    String sessionId;
    Format format;

    public Main(File csv, Properties configuration) {
        this.csv = csv;
        this.configuration = configuration;
        this.allowToAddMissingEntities = Boolean.parseBoolean(configuration.getProperty("allow.to.add.entities"));
        this.mergeUserDetailsOnUpdate = Boolean.parseBoolean(configuration.getProperty("merge.user.details.on.update"));
        this.delimiter = this.getDelimiter("csv.format.delimiter");
        try {
            this.serverApi = new XmlAPI(configuration.getProperty("xml.api.url"), () -> this.sessionId);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private char getDelimiter(String key) {
        String delimiter = this.configuration.getProperty(key);
        if (delimiter == null) {
            delimiter = ",";
        }
        delimiter = delimiter.trim();
        return delimiter.charAt(0);
    }

    public static void main(String[] args) {
        File csv = Main.validateCommandLine(args);
        Properties configuration = new Properties();
        try (FileReader reader = new FileReader("config.properties");){
            configuration.load(reader);
        }
        catch (IOException e) {
            System.err.println("Failed to read configuration: ");
            e.printStackTrace();
        }
        try {
            new Main(csv, configuration).run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void run() {
        this.authenticate();
        this.readCSV(parser -> {
            Map<String, Integer> headerMap = parser.getHeaderMap();
            this.format = this.detectFormat(headerMap);
        });
        this.format.runImport(this);
    }

    private Format detectFormat(Map<String, Integer> header) {
        if (this.containsKeys(header, "UserName", "FirstName", "LastName")) {
            return Format.users;
        }
        if (this.containsKeys(header, "Id", "Name", "ParentId")) {
            return Format.groups;
        }
        throw new RuntimeException("Unknown CSV format. Please check CSV file headers");
    }

    private boolean containsKeys(Map<String, Integer> header, String ... keys) {
        boolean contains = true;
        for (String key : keys) {
            contains &= header.containsKey(key);
        }
        return contains;
    }

    private void importUsers() {
        this.readCSVRecords(record -> {
            this.collect((CSVRecord)record, "Groups", this.groups);
            this.collect((CSVRecord)record, "Projects", this.projects);
            this.userNamesToImport.add(record.get("UserName"));
        });
        if (this.groups.containsKey(OPEN_LM_EVERYONE)) {
            System.out.println("WARNING: OpenLM_Everyone group is not allowed to add user to");
            this.groups.remove(OPEN_LM_EVERYONE);
        }
        this.loadAndUpdateGroups();
        this.loadAndUpdateProjects();
        this.readCSVRecords(this::importUser);
    }

    private void importGroups() {
        Map<String, String> existingGroups = this.serverApi.loadGroups();
        this.readCSVRecords(record -> {
            String name = record.get("Name");
            if (!existingGroups.containsKey(name)) {
                this.serverApi.createGroup(name);
            }
        });
        Map<String, String> allGroups = this.serverApi.loadGroups();
        HashMap fileToOpenLMIdMap = new HashMap();
        this.readCSVRecords(record -> {
            String name = record.get("Name");
            String fileId = record.get("Id");
            String openlmId = (String)allGroups.get(name);
            fileToOpenLMIdMap.put(fileId, openlmId);
        });
        this.readCSVRecords(record -> {
            String name = record.get("Name");
            String fileParentId = record.get("ParentId");
            String parentId = (String)fileToOpenLMIdMap.get(fileParentId);
            String fileId = record.get("Id");
            String id = (String)fileToOpenLMIdMap.get(fileId);
            Groups parents = this.serverApi.getGroupDetails(id, name);
            String prevParentId = parents.getList().isEmpty() ? (String)allGroups.get("OpenLM Groups") : parents.getList().get(0).getId();
            this.serverApi.updateGroup(id, name, parentId, prevParentId);
        });
    }

    private void importUser(CSVRecord csv) {
        String userName = csv.get("UserName");
        Optional<User> existingUser = this.serverApi.loadUser(userName);
        User csvUser = this.createUser(csv);
        if (existingUser.isPresent()) {
            if (this.mergeUserDetailsOnUpdate) {
                csvUser.merge(existingUser.get());
            }
            this.serverApi.updateUser(csvUser);
        } else if (this.allowToAddMissingEntities) {
            if (csvUser.enabled == null) {
                csvUser.enabled = true;
            }
            this.serverApi.createUser(csvUser);
        }
    }

    private User createUser(CSVRecord record) {
        return new User(record.get("UserName"), record.get("FirstName"), record.get("LastName"), record.get("DisplayName"), record.get("Title"), record.get("Department"), record.get("PhoneNumber"), record.get("Description"), record.get("Office"), record.get("Email"), this.nullableBoolean(record.get("Enabled")), this.existingIds(record.get("Groups"), this.groups), this.existingId(record.get("DefaultGroup"), this.groups), this.existingIds(record.get("Projects"), this.projects), this.existingId(record.get("DefaultProject"), this.projects));
    }

    private Boolean nullableBoolean(String value) {
        return value == null ? null : Boolean.valueOf(value);
    }

    private String existingId(String name, Map<String, String> idMap) {
        return idMap.get(name);
    }

    private List<String> existingIds(String line, Map<String, String> idMap) {
        if (line == null) {
            return null;
        }
        return Arrays.stream(line.split(this.listDelimiter)).filter(name -> idMap.get(name) != null).map(idMap::get).collect(Collectors.toList());
    }

    private void loadAndUpdateProjects() {
        if (this.projects.isEmpty()) {
            return;
        }
        this.loadId(this.serverApi::loadProjects, this.projects);
        if (this.allowToAddMissingEntities) {
            this.projects.entrySet().stream().filter(p -> p.getValue() == null).map(Map.Entry::getKey).forEach(this::createProject);
        }
    }

    private void createProject(String name) {
        this.projects.put(name, this.serverApi.createProject(name));
    }

    private void loadAndUpdateGroups() {
        if (this.groups.isEmpty()) {
            return;
        }
        this.loadId(this.serverApi::loadGroups, this.groups);
        if (this.allowToAddMissingEntities) {
            this.groups.entrySet().stream().filter(g -> g.getValue() == null).forEach(g -> this.serverApi.createGroup((String)g.getKey()));
            this.loadId(this.serverApi::loadGroups, this.groups);
        }
    }

    private void loadId(Supplier<Map<String, String>> loadMethod, Map<String, String> collected) {
        Map<String, String> existing = loadMethod.get();
        for (Map.Entry<String, String> entity : collected.entrySet()) {
            String name = entity.getKey();
            entity.setValue(existing.get(name));
        }
    }

    private void readCSV(Consumer<CSVParser> consumer) {
        try (BufferedReader reader = new BufferedReader(new FileReader(this.csv));){
            CSVParser parser = CSVFormat.DEFAULT.withHeader(new String[0]).withNullString("").withDelimiter(this.delimiter).parse(reader);
            consumer.accept(parser);
        }
        catch (IOException e) {
            throw new RuntimeException("CSV read failure", e);
        }
    }

    private void readCSVRecords(Consumer<CSVRecord> consumer) {
        this.readCSV(p -> p.iterator().forEachRemaining(consumer));
    }

    private void collect(CSVRecord record, String name, Map<String, String> collectTo) {
        String groups = record.get(name);
        if (groups != null) {
            String[] split;
            for (String s : split = groups.split(this.listDelimiter)) {
                collectTo.put(s, null);
            }
        }
    }

    private void authenticate() {
        if (this.serverApi.authRequired()) {
            String login = this.configuration.getProperty("login");
            String password = this.configuration.getProperty("password");
            if (login == null || login.isEmpty() || password == null || password.isEmpty()) {
                Console console = System.console();
                if (console != null) {
                    login = console.readLine("Authentication required. Please enter login: ", new Object[0]);
                    password = new String(console.readPassword("Password: ", new Object[0]));
                } else {
                    throw new RuntimeException("Authentication required. Configuration has no login nor password. Use java.exe instead of javaw.exe to enter credentials");
                }
            }
            this.sessionId = this.serverApi.authenticate(login, password);
        }
    }

    private static File validateCommandLine(String[] args) {
        File csv;
        if (args.length == 0) {
            System.out.println("Error: lack of arguments. Use CSV file name as the argument.");
            System.exit(0);
        }
        if (!(csv = new File(args[0])).exists()) {
            System.out.println("File not found: " + csv.getAbsolutePath());
            System.exit(1);
        }
        return csv;
    }

    static enum Format {
        users{

            @Override
            void runImport(Main main) {
                main.importUsers();
            }
        }
        ,
        groups{

            @Override
            void runImport(Main main) {
                main.importGroups();
            }
        };


        abstract void runImport(Main var1);
    }
}

